﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Data.SqlClient;
using System.Transactions;

namespace Transakcje
{
    public partial class Form1 : Form
    {
        SqlConnection connection =
            new SqlConnection(@"Data Source = DAWID-PC\SQLEXPRESS;Integrated Security = true");

        SqlTransaction sqlTransaction;

        public Form1()
        {
            InitializeComponent();
        }

        private bool czyBazaDanychIstnieje(string nazwaBazy)
        {
            string cmdText = "SELECT Count(*) FROM sys.databases WHERE name = \'"
                + nazwaBazy + "\'";
            SqlCommand sqlCmd = new SqlCommand(cmdText, connection);

            bool result = false;

            if (connection.State == ConnectionState.Closed)
                connection.Open();

            result = Convert.ToInt32(sqlCmd.ExecuteScalar()) > 0 ? true : false;
            connection.Close();

            return result;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            if (czyBazaDanychIstnieje("bank"))
            {
                MessageBox.Show("Baza danych już istnieje");
                return;
            }
            try
            {
                connection.Open();

                SqlCommand kwerenda = new SqlCommand();
                kwerenda.Connection = connection;

                // Utworzenie bazy danych o nazwie bank
                kwerenda.CommandText = "CREATE DATABASE bank";
                kwerenda.ExecuteNonQuery();

                // Rozpoczęcie transakcji
                sqlTransaction = connection.BeginTransaction();
                kwerenda.Transaction = sqlTransaction;

                // Utworzenie tabeli danych o nazwie Konta
                kwerenda.CommandText =
                    "CREATE TABLE bank..Konta(IDkonta int IDENTITY PRIMARY KEY, StanKonta decimal)";
                kwerenda.ExecuteNonQuery();

                // Wstawienie dwóch wierszy danych. Początkowy stan obu kont wynosi 0
                kwerenda.CommandText = "INSERT INTO bank..Konta Values('0')";
                kwerenda.ExecuteNonQuery();
                kwerenda.ExecuteNonQuery();

                // Próba wykonania operacji bazodanowych w ramach jednej transakcji
                sqlTransaction.Commit();

                // Odświeżenie danych
                button2_Click(sender, e);
                MessageBox.Show("Pomyślnie utworzono bazę danych", "Transakcje",
                    MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            catch (System.Exception ex)
            {
                // Cofnięcie wykonanych czynności
                sqlTransaction.Rollback();
                MessageBox.Show(ex.ToString(), "Transakcje",
                    MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            finally
            {
                connection.Close();
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            if (!czyBazaDanychIstnieje("bank"))
            {
                MessageBox.Show("Brak bazy danych!");
            }
            else
            {
                try
                {
                    SqlCommand kwerenda = new SqlCommand();
                    kwerenda.CommandText = "SELECT StanKonta FROM bank..Konta";
                    kwerenda.Connection = connection;
                    connection.Open();
                    using (SqlDataReader sdr = kwerenda.ExecuteReader())
                    {
                        sdr.Read();
                        stanPierwszegoKontaTB.Text = sdr[0].ToString();
                        sdr.Read();
                        stanDrugiegoKontaTB.Text = sdr[0].ToString();
                    }
                }
                catch (SqlException se)
                {
                    MessageBox.Show("W trakcie odczytu danych wystąpił błąd!\n"
                        + se.Message);
                }
                finally
                {
                    connection.Close();
                }
            }
        }

        private void button3_Click(object sender, EventArgs e)
        {
            if (!czyBazaDanychIstnieje("bank"))
            {
                MessageBox.Show("Brak bazy danych!");
                return;
            }

            try
            {
                SqlCommand kwerenda = new SqlCommand();
                connection.Open();
                sqlTransaction = connection.BeginTransaction(System.Data.IsolationLevel.RepeatableRead);
                kwerenda.Connection = connection;
                kwerenda.Transaction = sqlTransaction;

                // Pobranie kwoty przelewu i bilansu pierwszego konta
                decimal kwotaPrzelewu = Convert.ToDecimal(kwotaPrzelewuTB.Text);
                decimal bilans = Convert.ToDecimal(stanPierwszegoKontaTB.Text) - kwotaPrzelewu;

                // Aktualizacja danych w bazie
                kwerenda.CommandText = "UPDATE bank..Konta SET StanKonta = "
                    + bilans.ToString() + " WHERE IDkonta = 1";
                kwerenda.ExecuteNonQuery();

                // Pobranie bilansu drugiego konta i zwiększenie go o kwotę przelewu
                bilans = Convert.ToDecimal(stanDrugiegoKontaTB.Text) + kwotaPrzelewu;

                kwerenda.CommandText = "UPDATE bank..Konta SET StanKonta = "
                    + bilans.ToString() + " WHERE IDkonta = 2";
                kwerenda.ExecuteNonQuery();

                sqlTransaction.Commit();
            }
            catch (Exception ex)
            {
                sqlTransaction.Rollback();
                MessageBox.Show("W trakcie zmiany danych występił błąd!\n" + ex.Message);
            }
            finally
            {
                connection.Close();
                button2_Click(sender, e);
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            button2_Click(sender, e);

            for (int i = 0; i < 100; i += 10)
                comboBox1.Items.Add(i);
        }

private void button4_Click(object sender, EventArgs e)
{
    if (!czyBazaDanychIstnieje("bank"))
    {
        MessageBox.Show("Brak bazy danych!");
        return;
    }

    int ms = (comboBox1.SelectedItem == null)
        ? Convert.ToInt32(comboBox1.Text)
        : Convert.ToInt32(comboBox1.SelectedValue);

    using (TransactionScope scope
        = new TransactionScope(TransactionScopeOption.Required,
            new TimeSpan(0, 0, 0, 0, ms)))
    {
        try
        {
            SqlCommand kwerenda = new SqlCommand();
            kwerenda.Connection = connection;
            connection.Open();

            kwerenda.CommandText = "UPDATE bank..Konta SET StanKonta = '"
                + stanPierwszegoKontaTB.Text + "' WHERE IDkonta = 1";
            kwerenda.ExecuteNonQuery();

            // Wstrzymanie wykonywania wątku na 1000 ms
            System.Threading.Thread.Sleep(1000);

            kwerenda.CommandText = "UPDATE bank..Konta SET StanKonta = '"
                + stanDrugiegoKontaTB.Text + "' WHERE IDkonta = 2";
            kwerenda.ExecuteNonQuery();

            // Zatwierdzenie transakcji
            scope.Complete();
        }
        catch (Exception ex)
        {
            MessageBox.Show("W trakcie zmiany danych wystąpił błąd!\n" + ex.Message);
        }
        finally
        {
            connection.Close();
        }
    }
    // Odświeżenie danych
    button2_Click(sender, e);
}
    }
}
